/*
 * Decompiled with CFR 0.152.
 */
package optifine;

import cpw.mods.jarhandling.impl.Jar;
import cpw.mods.jarhandling.impl.SimpleJarMetadata;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import optifine.OptiFineTransformationService;

public class OptiFineJar
extends Jar {
    public OptiFineJar(Path ... paths) {
        super(Manifest::new, jar -> new SimpleJarMetadata("net.optifine", null, jar.getPackages(), new ArrayList()), (s1, s2) -> true, paths);
    }

    public Set<String> getPackages() {
        HashSet<String> set = new HashSet<String>();
        Enumeration<? extends ZipEntry> entries = OptiFineTransformationService.getOfZipFile().entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            String name = zipEntry.getName();
            if (!name.startsWith("srg/net/optifine/") || !name.endsWith(".class")) continue;
            set.add(name.substring(name.indexOf("/") + 1, name.lastIndexOf("/")).replace('/', '.'));
        }
        return set;
    }

    public Optional<URI> findFile(String name) {
        return OptiFineTransformationService.getResourceUrl(name).map(LamdbaExceptionUtils.rethrowFunction(URL::toURI));
    }
}

